/* Libart_LGPL - library of basic graphic primitives
 * Copyright (C) 1998 Raph Levien
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* Simple macros to set up storage allocation and basic types for libart
   functions. */
#include <stdlib.h> /* for malloc, etc. */
#include <math.h>
#include <string.h> /* for memmove */

/* The art_config.h file is automatically generated by
   gen_art_config.c and contains definitions of
   ART_SIZEOF_{CHAR,SHORT,INT,LONG} and art_u{8,16,32}. */

#define art_alloc malloc
#define art_free free
#define art_realloc realloc
#define art_new(type, n) ((type *)art_alloc ((n) * sizeof(type)))
#define art_renew(p, type, n) ((type *)art_realloc (p, (n) * sizeof(type)))
#define art_expand(p, type, max) do { if(max) { p = art_renew (p, type, max <<= 1); } else { max = 1; p = art_new(type, 1); } } while (0)

typedef int art_boolean;
#define ART_FALSE 0
#define ART_TRUE 1

typedef enum {
  ART_MOVETO,
  ART_MOVETO_OPEN,
  ART_CURVETO,
  ART_LINETO,
  ART_END
} ArtPathcode;

/* Basic data structures and constructors for simple vector paths */
typedef struct _ArtVpath ArtVpath;

/* CURVETO is not allowed! */
struct _ArtVpath {
  ArtPathcode code;
  double x;
  double y;
};

typedef struct _ArtPoint ArtPoint;

struct _ArtPoint {
  /*< public >*/
  double x, y;
};

typedef struct _ArtDRect ArtDRect;
typedef struct _ArtIRect ArtIRect;

struct _ArtDRect {
  /*< public >*/
  double x0, y0, x1, y1;
};

struct _ArtIRect {
  /*< public >*/
  int x0, y0, x1, y1;
};

typedef struct _ArtSVP ArtSVP;
typedef struct _ArtSVPSeg ArtSVPSeg;

struct _ArtSVPSeg {
  int n_points;
  int dir; /* == 0 for "up", 1 for "down" */
  ArtDRect bbox;
  ArtPoint *points;
};

struct _ArtSVP {
  int n_segs;
  ArtSVPSeg segs[1];
};

