/*
 * Decompiled with CFR 0.152.
 */
package net.dieslunae.jgraphite.ctrl;

import java.awt.image.BufferedImage;
import java.io.IOException;
import net.dieslunae.jgraphite.gui.FullScreenPreview;
import net.dieslunae.jgraphite.gui.MainView;
import net.dieslunae.jgraphite.model.ImageModel;
import net.dieslunae.jgraphite.model.ToneCurve;
import net.dieslunae.jgraphite.util.Settings;

public class JGraphiteController {
    private ImageModel model;
    private MainView view;
    private int lastBrightness = 0;

    public void setModel(ImageModel m) {
        this.model = m;
    }

    public void setView(MainView v) {
        this.view = v;
    }

    public void start() {
        this.view.init();
        this.view.setVisible(true);
    }

    public void loadImage() {
        String path = this.view.getLoadImagePath(Settings.getLastImagePath());
        this.loadImage(path);
    }

    public void loadImage(String path) {
        if (path != null) {
            this.view.displayBusyCursor();
            try {
                try {
                    this.model.loadImage(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.view.displayNormalCursor();
                    return;
                }
            }
            finally {
                this.view.displayNormalCursor();
            }
            Settings.setLastImagePath(path);
            this.view.upadeteWindowTitle(path);
            this.processImage();
        }
        this.view.updateBrightnessSlider();
    }

    public void saveImage() {
        String path = this.view.getSaveImagePath(Settings.getLastImagePath());
        if (path != null) {
            this.view.displayBusyCursor();
            try {
                try {
                    this.model.saveImage(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.view.displayNormalCursor();
                    return;
                }
            }
            finally {
                this.view.displayNormalCursor();
            }
            Settings.setLastImagePath(path);
            this.view.upadeteWindowTitle(path);
        }
    }

    public void setCustomCurve(ToneCurve curve) {
        Settings.TONE_CURVE = Settings.TONE_CURVE_INDEX_OF_CUSTOM;
        Settings.setCustomToneCurve(curve);
        this.view.setToneCurveSelection(Settings.TONE_CURVE);
        this.processImage();
    }

    public void processImage() {
        if (!this.model.isImageAvailable()) {
            return;
        }
        if (Settings.PROCESS_IMAGE) {
            this.model.convertImage();
            this.view.setThumbnail(this.model.getConvertedImage());
            this.view.upadateHistogram(this.model.getConvertedImage());
            this.view.updateToneCurve(Settings.getToneCurves().get(Settings.TONE_CURVE));
        } else {
            this.view.setThumbnail(this.model.getScaledImage());
            this.view.upadateHistogram(this.model.getScaledImage());
            this.view.updateToneCurve(null);
        }
    }

    public void changeToneCurve(int i) {
        Settings.TONE_CURVE = i;
        this.processImage();
    }

    public void changeGrayscaleConversionType(Settings.ConversionType t) {
        Settings.CONVERTSION_TYPE = t;
        this.processImage();
    }

    public BufferedImage getScaledConvertedImage(int w, int h) {
        return this.model.getScaledConvertedImage(w, h);
    }

    public int getAutoBrightnessLevel() {
        return this.model.getAutoBrightnessLevel();
    }

    public void displayPreview() {
        if (!this.model.isImageAvailable()) {
            return;
        }
        new FullScreenPreview(this);
    }

    public void autoBrightnessChanged() {
        if (Settings.AUTO_BRIGHTNESS) {
            Settings.BRIGHTNESS = this.lastBrightness;
            Settings.AUTO_BRIGHTNESS = false;
        } else {
            this.lastBrightness = Settings.BRIGHTNESS;
            Settings.AUTO_BRIGHTNESS = true;
        }
        this.view.updateBrightnessSlider();
        this.processImage();
    }
}

