/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.image.ImageToolTip;
import org.fibs.geotag.image.ThumbnailWorker;
import org.fibs.geotag.table.ImagesTableColumns;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.table.NavigableTable;
import org.fibs.geotag.table.TextCellEditor;
import org.fibs.geotag.tasks.TaskExecutor;
import org.fibs.geotag.util.FontUtil;
import org.fibs.geotag.util.Util;

public class ImagesTable
extends NavigableTable {
    private static final int GAP_IN_PIXELS = 8;
    private static final double ALTERNATIVE_BACKGROUND_RATIO = 0.1;
    private static final String ZEROS = "0000000000";
    private int mouseOnRow;
    private MouseEvent lastMouseMovedEvent;
    private Color alternativeBackground = this.calculateAlternativeBackgroundColour();
    private TextCellEditor textCellEditor;

    public ImagesTable(ImagesTableModel tableModel) {
        super(tableModel);
        this.setAutoResizeMode(0);
        this.determineColumnLayout();
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                if (event.getID() == 503) {
                    ImagesTable.this.setMouseOnRow(ImagesTable.this.rowAtPoint(event.getPoint()));
                    ImagesTable.this.setLastMouseMovedEvent(event);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 40: 
                    case 225: {
                        ImagesTable.this.navigateDown(event);
                        break;
                    }
                    case 38: 
                    case 224: {
                        ImagesTable.this.navigateUp(event);
                        break;
                    }
                }
                super.keyPressed(event);
            }
        });
        this.textCellEditor = new TextCellEditor(this);
        this.textCellEditor.setFont(this.getFont());
        this.textCellEditor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setDefaultEditor(String.class, new DefaultCellEditor(this.textCellEditor));
        Settings.SettingsListener settingsListener = new Settings.SettingsListener(){

            @Override
            public void settingChanged(Settings.SETTING setting) {
                int clicksToEdit = Settings.get(Settings.SETTING.CLICKS_TO_EDIT, 1);
                ((DefaultCellEditor)ImagesTable.this.getDefaultEditor(String.class)).setClickCountToStart(clicksToEdit);
            }
        };
        settingsListener.settingChanged(Settings.SETTING.CLICKS_TO_EDIT);
        Settings.addListener(Settings.SETTING.CLICKS_TO_EDIT, settingsListener);
        this.fixBug6503981();
        this.usePreferredFont();
        this.setupActions();
    }

    private void fixBug6503981() {
        final JTableHeader header = this.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                int column = header.getColumnModel().getColumnIndexAtX(event.getPoint().x);
                if (column >= 0) {
                    ImagesTable.this.setColumnSelectionInterval(column, column);
                    Action focusAction = ImagesTable.this.getActionMap().get("focusHeader");
                    focusAction.actionPerformed(new ActionEvent(ImagesTable.this, 0, "focusHeader"));
                }
            }
        });
    }

    private void setupActions() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(40, 0, false), "downArrow");
        AbstractAction downArrow = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        };
        this.getActionMap().put("downArrow", downArrow);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(38, 0, false), "upArrow");
        AbstractAction upArrow = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        };
        this.getActionMap().put("upArrow", upArrow);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(37, 0, false), "leftArrow");
        AbstractAction leftArrow = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        };
        this.getActionMap().put("leftArrow", leftArrow);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(39, 0, false), "rightArrow");
        AbstractAction rightArrow = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        };
        this.getActionMap().put("rightArrow", rightArrow);
    }

    private Color calculateAlternativeBackgroundColour() {
        double ratio = 0.1;
        int red = (int)Util.applyRatio(this.getBackground().getRed(), this.getForeground().getRed(), ratio);
        int green = (int)Util.applyRatio(this.getBackground().getGreen(), this.getForeground().getGreen(), ratio);
        int blue = (int)Util.applyRatio(this.getBackground().getBlue(), this.getForeground().getBlue(), ratio);
        return new Color(red, green, blue);
    }

    private Settings.SETTING getColumnWidthSetting(ImagesTableColumns.COLUMN column) {
        Settings.SETTING setting = null;
        try {
            setting = Settings.SETTING.valueOf(String.valueOf(column.name()) + "_WIDTH");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return setting;
    }

    private Settings.SETTING getColumnPositionSetting(ImagesTableColumns.COLUMN column) {
        Settings.SETTING setting = null;
        try {
            setting = Settings.SETTING.valueOf(String.valueOf(column.name()) + "_POSITION");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return setting;
    }

    private void determineColumnLayout() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String[] correctOrder = new String[ImagesTableColumns.COLUMN.values().length];
        int index = 0;
        while (index < ImagesTableColumns.COLUMN.values().length) {
            ImagesTableColumns.COLUMN column = ImagesTableColumns.COLUMN.values()[index];
            int preferredWidth = 0;
            switch (column) {
                case ALTITUDE: {
                    preferredWidth = this.defaultAltitudeWidth(fontMetrics);
                    break;
                }
                case DIRECTION: {
                    preferredWidth = this.defaultDirectionWidth(fontMetrics);
                    break;
                }
                case GPS_DATE: {
                    preferredWidth = this.defaultDateWidth(fontMetrics);
                    break;
                }
                case CAMERA_DATE: {
                    preferredWidth = this.defaultDateWidth(fontMetrics);
                    break;
                }
                case LATITUDE: {
                    preferredWidth = this.defaultLatitudeWidth(fontMetrics);
                    break;
                }
                case LONGITUDE: {
                    preferredWidth = this.defaultLongitudeWidth(fontMetrics);
                    break;
                }
                case TIME_OFFSET: {
                    preferredWidth = this.defaultOffsetWidth(fontMetrics);
                    break;
                }
                case IMAGE_NAME: {
                    preferredWidth = this.defaultImageNameWidth(fontMetrics);
                    break;
                }
                case LOCATION_NAME: {
                    preferredWidth = this.defaultLocationNameWidth(fontMetrics);
                    break;
                }
                case CITY_NAME: {
                    preferredWidth = this.defaultCityNameWidth(fontMetrics);
                    break;
                }
                case PROVINCE_NAME: {
                    preferredWidth = this.defaultProvinceNameWidth(fontMetrics);
                    break;
                }
                case COUNTRY_NAME: {
                    preferredWidth = this.defaultCountryNameWidth(fontMetrics);
                    break;
                }
                case USER_COMMENT: {
                    preferredWidth = this.defaultUserCommentWidth(fontMetrics);
                    break;
                }
            }
            preferredWidth += 8;
            Settings.SETTING setting = this.getColumnWidthSetting(column);
            if (setting != null) {
                preferredWidth = Settings.get(setting, preferredWidth);
            }
            String columnName = this.getModel().getColumnName(index);
            int columnIndex = this.getColumnModel().getColumnIndex(columnName);
            this.getColumnModel().getColumn(columnIndex).setPreferredWidth(preferredWidth);
            setting = this.getColumnPositionSetting(column);
            int newColumnIndex = Settings.get(setting, columnIndex);
            if (correctOrder[newColumnIndex] == null) {
                correctOrder[newColumnIndex] = columnName;
            } else {
                int check = 0;
                while (check < ImagesTableColumns.COLUMN.values().length) {
                    if (correctOrder[check] == null) {
                        correctOrder[check] = columnName;
                    }
                    ++check;
                }
            }
            ++index;
        }
        index = 0;
        while (index < correctOrder.length) {
            String columnName = correctOrder[index];
            int currentIndex = this.getColumnModel().getColumnIndex(columnName);
            this.getColumnModel().moveColumn(currentIndex, index);
            ++index;
        }
    }

    public void saveColumnSettings() {
        int index = 0;
        while (index < ImagesTableColumns.COLUMN.values().length) {
            String columnName = this.getModel().getColumnName(index);
            int columnIndex = this.getColumnModel().getColumnIndex(columnName);
            ImagesTableColumns.COLUMN column = ImagesTableColumns.COLUMN.values()[index];
            Settings.SETTING setting = this.getColumnWidthSetting(column);
            if (setting != null) {
                int width = this.getColumnModel().getColumn(columnIndex).getPreferredWidth();
                Settings.put(setting, width);
            }
            if ((setting = this.getColumnPositionSetting(column)) != null) {
                Settings.put(setting, columnIndex);
            }
            ++index;
        }
    }

    private int defaultImageNameWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth("20000000_000000.jpg");
    }

    private int defaultOffsetWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth("-99:99:99");
    }

    private int defaultLongitudeWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth("-180." + ZEROS.substring(0, 7));
    }

    private int defaultLatitudeWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth("-90." + ZEROS.substring(0, 7));
    }

    private int defaultDateWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth("2000:00:00 00:00:00");
    }

    private int defaultAltitudeWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth("19999." + ZEROS.substring(0, 1));
    }

    private int defaultDirectionWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth("359." + ZEROS.substring(0, 1));
    }

    private int defaultLocationNameWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth("Greenwich");
    }

    private int defaultCityNameWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth("Greater London");
    }

    private int defaultProvinceNameWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth("England");
    }

    private int defaultCountryNameWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth("United Kingdom");
    }

    private int defaultUserCommentWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth("Some sort of description");
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        Font font = this.getFont();
        ImageInfo imageInfo = ((ImagesTableModel)this.getModel()).getImageInfo(row);
        if (component instanceof DefaultTableCellRenderer) {
            String text = ((ImagesTableModel)this.getModel()).getImageInfo(row).getPath();
            if (imageInfo.getThumbnail() != null) {
                text = String.valueOf(text) + ' ';
            }
            ((DefaultTableCellRenderer)component).setToolTipText(text);
        }
        if (imageInfo.hasNewLocation()) {
            font = font.deriveFont(1);
        }
        component.setFont(font);
        if (!this.isCellSelected(row, column)) {
            Color background = this.getBackground();
            if (row % 2 == 0) {
                background = this.alternativeBackground;
            }
            component.setBackground(background);
        }
        return component;
    }

    public void usePreferredFont() {
        Font font;
        String fontId = Settings.get(Settings.SETTING.FONT, null);
        if (fontId != null && (font = FontUtil.fontFromID(Settings.get(Settings.SETTING.FONT, null))) != null) {
            this.setFont(font);
            this.textCellEditor.setFont(font);
            int borderInsets = 0;
            Border border = this.textCellEditor.getBorder();
            if (border != null) {
                Insets insets = border.getBorderInsets(this.textCellEditor);
                borderInsets += insets.bottom + insets.top;
            }
            this.textCellEditor.getBorder();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            this.setRowHeight(fontMetrics.getHeight() + borderInsets);
            this.invalidate();
        }
    }

    @Override
    public JToolTip createToolTip() {
        ImageInfo imageInfo = ((ImagesTableModel)this.getModel()).getImageInfo(this.mouseOnRow);
        ImageIcon imageIcon = imageInfo.getThumbnail();
        final ImageToolTip tooltip = new ImageToolTip(imageIcon, imageInfo.getPath());
        boolean showThumbnails = Settings.get(Settings.SETTING.TUMBNAILS_IN_TOOLTIPS, true);
        if (imageIcon == null && showThumbnails && imageInfo.getThumbNailStatus() == ImageInfo.THUMBNAIL_STATUS.UNKNOWN) {
            ThumbnailWorker worker = new ThumbnailWorker(imageInfo){

                @Override
                protected void process(List<ImageInfo> chunks) {
                    if (tooltip.isShowing()) {
                        tooltip.setImageIcon(chunks.get(0).getThumbnail());
                        ImagesTable.this.dispatchEvent(ImagesTable.this.getLastMouseMovedEvent());
                    }
                }
            };
            TaskExecutor.execute(worker);
        }
        return tooltip;
    }

    public void selectAllWithLocation() {
        this.clearSelection();
        int row = 0;
        while (row < this.getRowCount()) {
            ImageInfo imageInfo = ((ImagesTableModel)this.getModel()).getImageInfo(row);
            if (imageInfo.hasLocation()) {
                this.addRowSelectionInterval(row, row);
            }
            ++row;
        }
    }

    public void selectAllWithNewLocation() {
        this.clearSelection();
        int row = 0;
        while (row < this.getRowCount()) {
            ImageInfo imageInfo = ((ImagesTableModel)this.getModel()).getImageInfo(row);
            if (imageInfo.hasNewLocation()) {
                this.addRowSelectionInterval(row, row);
            }
            ++row;
        }
    }

    public void selectNone() {
        this.clearSelection();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        JTableHeader defaultTableHeader = new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                int columnIndex = this.columnModel.getColumnIndexAtX(e.getPoint().x);
                int modelIndex = this.columnModel.getColumn(columnIndex).getModelIndex();
                ImagesTableColumns.COLUMN column = ImagesTableColumns.COLUMN.values()[modelIndex];
                return ImagesTableColumns.getDescription(column);
            }
        };
        return defaultTableHeader;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    MouseEvent getLastMouseMovedEvent() {
        return this.lastMouseMovedEvent;
    }

    void setLastMouseMovedEvent(MouseEvent lastMouseMovedEvent) {
        this.lastMouseMovedEvent = lastMouseMovedEvent;
    }

    int getMouseOnRow() {
        return this.mouseOnRow;
    }

    void setMouseOnRow(int mouseOnRow) {
        this.mouseOnRow = mouseOnRow;
    }
}

